<?php
/* --------------------------------------------------------------
   LanguageCode.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Model;

/**
 * Class LanguageCode
 *
 * @package Gambio\Core\Language\Model
 */
class LanguageCode implements \Gambio\Core\Language\LanguageCode
{
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * LanguageCode constructor.
     *
     * @param string $value
     */
    private function __construct(string $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * @param string $value
     *
     * @return LanguageCode
     */
    public static function create(string $value): LanguageCode
    {
        return new self($value);
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): string
    {
        return $this->value;
    }
}